<?php
/**
 * PayNow Integration Migration
 * 
 * Adds new fields for PayNow API integration:
 * - merchant_id
 * - merchant_email
 * - merchant_mobile
 * - webhook_url
 * - return_url
 * 
 * Run this migration to update the payment_gateway_settings table
 */

require_once 'config/database.php';

$db = getDB();

echo "Starting PayNow fields migration...\n";

try {
    // Check if columns already exist
    $stmt = $db->query("SHOW COLUMNS FROM payment_gateway_settings LIKE 'merchant_id'");
    $hasMerchantId = $stmt->fetch();
    
    if (!$hasMerchantId) {
        echo "Adding merchant_id column...\n";
        $db->exec("ALTER TABLE payment_gateway_settings ADD COLUMN merchant_id VARCHAR(100) DEFAULT NULL AFTER api_secret");
    }
    
    $stmt = $db->query("SHOW COLUMNS FROM payment_gateway_settings LIKE 'merchant_email'");
    $hasMerchantEmail = $stmt->fetch();
    
    if (!$hasMerchantEmail) {
        echo "Adding merchant_email column...\n";
        $db->exec("ALTER TABLE payment_gateway_settings ADD COLUMN merchant_email VARCHAR(255) DEFAULT NULL AFTER merchant_id");
    }
    
    $stmt = $db->query("SHOW COLUMNS FROM payment_gateway_settings LIKE 'merchant_mobile'");
    $hasMerchantMobile = $stmt->fetch();
    
    if (!$hasMerchantMobile) {
        echo "Adding merchant_mobile column...\n";
        $db->exec("ALTER TABLE payment_gateway_settings ADD COLUMN merchant_mobile VARCHAR(20) DEFAULT NULL AFTER merchant_email");
    }
    
    $stmt = $db->query("SHOW COLUMNS FROM payment_gateway_settings LIKE 'webhook_url'");
    $hasWebhookUrl = $stmt->fetch();
    
    if (!$hasWebhookUrl) {
        echo "Adding webhook_url column...\n";
        $db->exec("ALTER TABLE payment_gateway_settings ADD COLUMN webhook_url VARCHAR(500) DEFAULT NULL AFTER merchant_mobile");
    }
    
    $stmt = $db->query("SHOW COLUMNS FROM payment_gateway_settings LIKE 'return_url'");
    $hasReturnUrl = $stmt->fetch();
    
    if (!$hasReturnUrl) {
        echo "Adding return_url column...\n";
        $db->exec("ALTER TABLE payment_gateway_settings ADD COLUMN return_url VARCHAR(500) DEFAULT NULL AFTER webhook_url");
    }
    
    echo "PayNow fields migration completed successfully!\n";
    
} catch (PDOException $e) {
    echo "Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}

/**
 * Insert sample PayNow sandbox settings if not exists
 */
function insertPayNowSandboxSettings($db)
{
    $stmt = $db->prepare("
        SELECT id FROM payment_gateway_settings
        WHERE gateway_name = 'paynow' AND gateway_type = 'sandbox'
    ");
    $stmt->execute();
    
    if (!$stmt->fetch()) {
        echo "Inserting sample PayNow sandbox settings...\n";
        
        // IMPORTANT: Replace these with your actual PayNow sandbox credentials
        // Get these from: https://www.paynow.co.zw/developer/integration
        $stmt = $db->prepare("
            INSERT INTO payment_gateway_settings
            (gateway_name, gateway_type, is_active, api_key, api_secret, merchant_id, 
             merchant_email, merchant_mobile, webhook_url, return_url, created_at)
            VALUES ('paynow', 'sandbox', 0, '1234', 'abcd1234', 'MUTALEX001',
                    'payments@mutalexacademy.com', '263771234567',
                    'https://yourdomain.com/api/webhooks/paynow.php',
                    'https://yourdomain.com/student/checkout.php?status=callback',
                    NOW())
        ");
        $stmt->execute();
        
        echo "Sample settings inserted. IMPORTANT: Update with your actual credentials!\n";
    }
}

insertPayNowSandboxSettings($db);

echo "\nMigration complete!\n";
echo "\nIMPORTANT: Update your PayNow credentials in the database:\n";
echo "1. Log in to admin panel\n";
echo "2. Go to Payment Gateways settings\n";
echo "3. Update PayNow sandbox credentials with your test Integration ID and Key\n";
echo "4. Get credentials from: https://www.paynow.co.zw/developer/integration\n";
